VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "pgAdmin2_Exporter"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' pgAdmin II - PostgreSQL Tools
' Copyright (C) 2001 - 2003, The pgAdmin Development Team
' This software is released under the pgAdmin Public Licence

Option Explicit

Implements pgExporter

Private Property Get pgExporter_Description() As String
  pgExporter_Description = "OLE Link to MS Access"
End Property

Private Property Get pgExporter_Version() As String
  pgExporter_Version = App.Major & "." & App.Minor & "." & App.Revision
End Property

Private Property Get pgExporter_Author() As String
  pgExporter_Author = "Written by Frank_Lupo" & vbCrLf & _
                      "http://www.pgadmin.org/"
End Property

Private Sub pgExporter_Export(rsData As Variant)
On Error Resume Next
Dim X As Integer
Dim AccessApp As Object
Dim szSqlInsert As String
Dim szSqlCreate As String
Dim szSql As String
Dim iLng As Integer
  
  frmExport.Show vbModal
  If frmExport.txtFileName = "" Then
    MsgBox "No filename specified, export aborted!", vbExclamation, "Error"
    Exit Sub
  End If
  
  Set AccessApp = CreateObject("Access.Application")
  AccessApp.Visible = True

  'create new project
  AccessApp.NewCurrentDatabase frmExport.txtFileName

  szSqlInsert = "insert into Result ("
  szSqlCreate = "Create table Result ("
  For X = 0 To rsData.Fields.Count - 1
    szSqlInsert = szSqlInsert & " " & rsData.Fields(X).Name & " "
    szSqlCreate = szSqlCreate & " " & rsData.Fields(X).Name & " "
    Select Case rsData.Fields(X).Type
      Case adInteger, adBinary, adUnsignedInt
        szSqlCreate = szSqlCreate & " Integer "
      Case adBoolean
        szSqlCreate = szSqlCreate & " Boolean "
      Case adUnsignedTinyInt
        szSqlCreate = szSqlCreate & " Byte "
      Case adCurrency
        szSqlCreate = szSqlCreate & " Money "
      Case adDate, adDBDate
        szSqlCreate = szSqlCreate & " Date "
      Case adDBTime
        szSqlCreate = szSqlCreate & " Time "
      Case adDBTimeStamp
        szSqlCreate = szSqlCreate & " TimeStamp "
      Case adDouble
        szSqlCreate = szSqlCreate & " Double "
      Case adLongVarBinary
        szSqlCreate = szSqlCreate & " LongBinary "
      Case adLongVarWChar
        szSqlCreate = szSqlCreate & " LongText "
      Case adSingle
        szSqlCreate = szSqlCreate & " Single "
      Case adSmallInt
        szSqlCreate = szSqlCreate & " Short "
      Case adVarWChar, adLongVarChar
        szSqlCreate = szSqlCreate & " Text "
      Case adChar
        iLng = rsData.Fields(X).DefinedSize
        If iLng > 255 Then iLng = 255
        szSqlCreate = szSqlCreate & " Char(" & iLng & ") "
      Case adVarChar
        iLng = rsData.Fields(X).DefinedSize
        If iLng > 255 Then iLng = 255
        szSqlCreate = szSqlCreate & " Varchar(" & iLng & ") "
      Case Else
        Err.Raise -1, , "Type field not found !! " & rsData.Fields(X).Type
        Exit Sub
    End Select
    If X < rsData.Fields.Count - 1 Then
      szSqlCreate = szSqlCreate & " ,"
      szSqlInsert = szSqlInsert & " ,"
    End If
  Next
  szSqlCreate = szSqlCreate & " )"
  szSqlInsert = szSqlInsert & " ) values ("

  'Create table
  AccessApp.CurrentDb.Execute szSqlCreate

  'Enter Data
  While Not rsData.EOF
    szSql = szSqlInsert
    For X = 0 To rsData.Fields.Count - 1
      Select Case rsData.Fields(X).Type
        Case adInteger, adBinary, adUnsignedInt
          szSql = szSql & rsData.Fields(X).Value
        Case adBoolean
          szSql = szSql & rsData.Fields(X).Value
        Case adUnsignedTinyInt
          szSql = szSql & rsData.Fields(X).Value
        Case adCurrency
          szSql = szSql & "'" & rsData.Fields(X).Value & "'"
        Case adDate, adDBDate
          szSql = szSql & "'" & rsData.Fields(X).Value & "'"
        Case adDBTime
          szSql = szSql & "'" & rsData.Fields(X).Value & "'"
        Case adDBTimeStamp
          szSql = szSql & "'" & rsData.Fields(X).Value & "'"
        Case adDouble
          szSql = szSql & rsData.Fields(X).Value
        Case adLongVarBinary
          szSql = szSql & rsData.Fields(X).Value
        Case adLongVarWChar
          szSql = szSql & "'" & rsData.Fields(X).Value & "'"
        Case adSingle
          szSql = szSql & rsData.Fields(X).Value
        Case adSmallInt
          szSql = szSql & rsData.Fields(X).Value
        Case adVarWChar, adLongVarChar
          szSql = szSql & "'" & rsData.Fields(X).Value & "'"
        Case adChar
          szSql = szSql & "'" & rsData.Fields(X).Value & "'"
        Case adVarChar
          szSql = szSql & "'" & rsData.Fields(X).Value & "'"
        Case Else
          szSql = szSql & "'" & rsData.Fields(X).Value & "'"
      End Select
      If X < rsData.Fields.Count - 1 Then szSql = szSql & " ,"
    Next
    szSql = szSql & " ) "
    AccessApp.CurrentDb.Execute szSql
    rsData.MoveNext
  Wend

  Screen.MousePointer = vbNormal
End Sub
