//////////////////////////////////////////////////////////////////////////
//
// pgAdmin III - PostgreSQL Tools
// Copyright (C) 2002, The pgAdmin Development Team
// This software is released under the pgAdmin Public Licence
//
// frmChildfrmChildTableViewFrame.h - The query builder child frames
//
//////////////////////////////////////////////////////////////////////////

#include "frmQueryBuilder.h"

////////////////////////////////////////////////////////////////////////////////
// Event Table
////////////////////////////////////////////////////////////////////////////////
BEGIN_EVENT_TABLE(frmChildTableViewFrame, wxMDIChildFrame)

	EVT_LISTBOX_DCLICK(ID_TABLEVIEWLISTBOX,OnDoubleClick)

END_EVENT_TABLE()

////////////////////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////////////////////
frmChildTableViewFrame::frmChildTableViewFrame(wxMDIParentFrame *parent, 
											   wxString title)
{
	// Create the frame
	this->Create(parent, -1, title, wxDefaultPosition, wxSize(100, 200));

	// Create a boxsizer for the frame to control layout
	m_sizer = new wxBoxSizer(wxVERTICAL);

	// Create a column list
	m_columnlist = new wxListBox(this, ID_TABLEVIEWLISTBOX, 
		wxDefaultPosition, wxDefaultSize, 0, NULL, wxLB_NEEDED_SB );

	// Add the column list to the sizer
	m_sizer->Add(m_columnlist, 1, wxEXPAND, 0 );

	// Size hints (because the window is sizable)
	m_sizer->SetSizeHints( this );

	// Set the sizer for the frame
	SetSizer( m_sizer );
}

////////////////////////////////////////////////////////////////////////////////
// Destructor
////////////////////////////////////////////////////////////////////////////////
frmChildTableViewFrame::~frmChildTableViewFrame()
{
	frmQueryBuilder *tmpparent = (frmQueryBuilder*)this->GetParent();

//	tmpparent->m_children.DeleteObject(this);
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
void frmChildTableViewFrame::OnDoubleClick(wxCommandEvent& event)
{
	frmQueryBuilder *tmpparent = (frmQueryBuilder*)this->GetParent();

	int tmpitem = event.GetInt();
	tmpparent->AddColumn(this, tmpitem);
}
