#!/bin/bash

# To setup the subscriber.

# The parameter is which streaming mode to test, 'parallel' or 'on'. For 'on'
# mode, test based on HEAD; for 'parallel' mode, test based on patched code.
# This should be the same as the 1st parameter of start_pub.sh.

# If you want to run this script, you might need to change the install path in
# the scripts:
#  path_parallel_apply : install path of patched code.
#  path_master : install path of HEAD.

# The host of publisher in CREATE SUBSCRIPTION command might need to be changed.

path_parallel_apply=/home/fnst/data/shiy/install_pa/bin/
path_master=/home/fnst/data/shiy/install_head/bin/

if [ "$1" = "on" ]; then
    path=$path_master
elif [ "$1" = "parallel" ]; then
    path=$path_parallel_apply
fi

echo path=${path}

pub_port=5432
sub_port=5433

${path}pg_ctl -D data_sub stop -m i
rm -rf data_sub sub.log

${path}initdb -D data_sub -U postgres

cat << EOF >> data_sub/postgresql.conf
listen_addresses = '*'
wal_level = logical
port = $sub_port
shared_buffers = 8GB
checkpoint_timeout = 30min
max_wal_size = 20GB
min_wal_size = 10GB
autovacuum = off
EOF

${path}pg_ctl -D data_sub start -l sub.log

${path}psql -d postgres -U postgres -p $sub_port -c "CREATE TABLE large_test (\
     id int primary key,\
     num1 bigint,\
     num2 double precision,\
     num3 double precision\
);"

${path}psql -d postgres -U postgres -p $sub_port -c "create subscription sub connection 'host=foo port=$pub_port dbname=postgres user=postgres ' publication pub with(streaming=$1);"
